<?php
/**
 * Description: Register Slider as a widget
 *
 * @file
 * @package MultiPurpose Before After Slider.
 */

add_action( 'widgets_init', 'baslider_register_widgets' );

/**
 * Baslider register widgets.
 */
function baslider_register_widgets() {
	register_widget( 'BASlider_Widget' );
}

/**
 * Register Sidebar as Widget.
 */
class BASlider_Widget extends WP_Widget {
	/**
	 * Constructor
	 */
	public function __construct() {
		// Instantiate the parent object.
		parent::__construct(
			'baslider-widget', // Base ID.
			'BASlider Widget', // Name.
			array( 'description' => __( 'Before After Gallery', 'baslider' ) ) // Args.
		);
	}
	/**
	 * Widget output.
	 *
	 * @param string $args .
	 * @param string $instance .
	 */
	public function widget( $args, $instance ) {

		if ( isset( $instance['title'] ) ) {
			$title = $instance['title'];
		} else {
			$title = __( 'Before After Slider', 'baslider' );
		}

		if ( isset( $instance['baslider'] ) ) {
			$baslider = $instance['baslider'];
		} else {
			$baslider = __( 'slider1', 'baslider' );
		}

		if ( isset( $instance['description1'] ) ) {
			$description1 = $instance['description1'];
		} else {
			$description1 = '';
		}

		if ( isset( $instance['description2'] ) ) {
			$description2 = $instance['description2'];
		} else {
			$description2 = '';
		}

		wp_enqueue_script( 'baslider' );
		wp_enqueue_script( 'baslider_event' );
		wp_enqueue_style( 'baslider_main_style' );
		add_action( 'wp_footer', array( 'ba_slider', 'scripts_footer' ) );

		echo wp_kses_post( $args['before_widget'] );

		echo wp_kses_post( ( $args['before_title'] . $title . $args['after_title'] ) );

		echo '<p>' . esc_attr( $description1 ) . '</p>';
		display_baslider( $baslider ); // check.

		echo '<p>' . esc_attr( $description2 ) . '</p>';
		echo wp_kses_post( $args['after_widget'] );
	}
	/**
	 * Save widget options.
	 *
	 * @param string $new_instance User option key.
	 * @param string $old_instance User option key.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance                 = array();
		$instance['title']        = ( ! empty( $new_instance['title'] ) ) ? wp_strip_all_tags( $new_instance['title'] ) : '';
		$instance['baslider']     = $new_instance['baslider'];
		$instance['description1'] = $new_instance['description1'];
		$instance['description2'] = $new_instance['description2'];

		return $instance;
	}
	/**
	 * Save widget options.
	 *
	 * @param string $instance User option key.
	 */
	public function form( $instance ) {

		if ( isset( $instance['title'] ) ) {
			$title = $instance['title'];
		} else {
			$title = __( 'Before After Slider', 'baslider' );
		}

		if ( isset( $instance['baslider'] ) ) {
			$baslider = $instance['baslider'];
		} else {
			$baslider = __( 'slider1', 'baslider' );
		}

		if ( isset( $instance['description1'] ) ) {
			$description1 = $instance['description1'];
		} else {
			$description1 = '';
		}

		if ( isset( $instance['description2'] ) ) {
			$description2 = $instance['description2'];
		} else {
			$description2 = '';
		}

		// Output admin widget options form.
		?>
		<p><label for="<?php echo esc_html( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'baslider' ); ?>:</label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
				name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title ); ?>"
				style="width:95%;"/></p>

		<p>
			<label
				for="<?php echo esc_html( $this->get_field_id( 'description1' ) ); ?>"><?php esc_html_e( 'Description 1 (optional)', 'baslider' ); ?>
				:</label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'description1' ) ); ?>"
				name="<?php echo esc_attr( $this->get_field_name( 'description1' ) ); ?>"
				value="<?php echo esc_attr( $description1 ); ?>" style="width:95%;"/>
		</p>

		<p><label><?php esc_html_e( 'Choose Slider', 'baslider' ); ?>:</label><br/>
			<select id="<?php echo esc_attr( $this->get_field_name( 'baslider' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'baslider' ) ); ?>">
				<?php
				$sliders_data = get_option( 'baslider' );
				foreach ( $sliders_data as $data ) {
					?>
					<option value="<?php echo esc_attr( $data ); ?>" 
											<?php
											if ( $data == $baslider ) {
												echo 'selected="selected"';
											}
											?>
					><?php echo esc_attr( $data ); ?></option>
					<?php
				}
				?>
			</select>
		</p>
		<p>
			<label
				for="<?php echo esc_html( $this->get_field_id( 'description2' ) ); ?>"><?php esc_html_e( 'Description 2 (optional)', 'baslider' ); ?>
				:</label>
			<input type="text" id="<?php echo esc_attr( $this->get_field_id( 'description2' ) ); ?>"
				name="<?php echo esc_attr( $this->get_field_name( 'description2' ) ); ?>"
				value="<?php echo esc_attr( $description2 ); ?>" style="width:95%;"/></p>
		<?php
	}
}

// Use shortcodes in text widgets.
add_filter( 'widget_text', 'do_shortcode' );
